### Incremental Randomized Smoothing Certification
  This repository contains the code for the paper [Incremental Randomized Smoothing Certification](). The models used for the experiments can be found [here](). 
  
  Incremental Randomized Smoothing (IRS) is the first approach for efficient incremental robustness certification for randomized smoothing(RS).  Given an original network $f$ and its smoothed version $g$, and a modified network $f^p$ with its smoothed version $g^p$, IRS incrementally certifies the robustness of $g^p$ by reusing the information from the execution of RS certification on $g$. The figure below presents the high-level workflow of IRS.
    
  IRS takes the original classifier $f$ and input $x$. It is built on top of the standard RS framework. IRS reuses the $\underline{pA}$ and $\underline{pB}$ estimates computed for $f$ on $x$ by RS. IRS estimate $ζx$, the upper bound on the probability that outputs of $f$ and $f^p$ are distinct, from $f$ and $f^p$. For the smoothed classifier $g^p$ obtained from the updated classifier $f^p$ it computes the certified radius by combining $\underline{pA}$ and $\underline{pB}$ with $ζx$.
  
  We extensively evaluate the performance of IRS on state-of-the-art models on CIFAR10 (ResNet-20,ResNet-110) and ImageNet (ResNet-50) datasets, considering several common approximations such as pruning and quantization. Our results demonstrate speedups of up to 3x over the standard non-incremental RS baseline, highlighting the effectiveness of IRS in improving certification efficiency.
  
### Installation and Setup in a Virtual Environment
  #### Step 1: Virtual Environment Setup
  ##### Conda 
  First, make sure you have conda. Refer to the following link for an installation guide. https://conda.io/projects/conda/en/latest/user-guide/install/index.html
  To create the virtual environment,
  
  `conda create --name env`
  
  Then to enter the virtual environment, run
  
  `conda activate env`
  
  ##### venv
  
  In addition to Conda, venv (https://docs.python.org/3/library/venv.html) can be used to run IRS in a virtual environment. 
  If venv is not already installed, install it with the following command (Use appropriate python version)

  `sudo apt-get install python3.8-venv` 

  To create the virtual environment,

  `python3 -m venv env`

  Then to enter the virtual environment, run

  `source env/bin/activate`

  
  #### Step 2: Dependencies Installation
  Following the creation of the conda environment or venv, install all packages with
  
  `pip install -r requirements.txt`
  
  Finally run, 
  
  `pip install --upgrade torch torchvision`
  
  #### Step 3: Downloading Trained Models
  Download the networks used for the experiment [here](https://drive.google.com/file/d/1h_TpbXm5haY5f-l4--IKylmdz6tvPoR4).
  
  Then, move the networks to `nnverify/nets`.
  
  Finally, create an environment variable for ImageNet path with the following command.
  
  `export IMAGENET_DIR= $PATH_TO_IMAGENET`
  
### Running experiments
  #### Caveats
   1. The speedup results obtained in the experiment can vary depending on the machine.
  
   2. Our experiments run the Incremental Randomized Smoothing (IRS) algorithm and baseline randomized smoothing approach on a range of sample sizes. We compute and report the average speedup in certification time for a particular average certified radius (ACR). The speedup results in the paper are for sample values from {1%, … 10%} of the sample size used to certify the original network, enabling a fast recertification while maintaining a sufficiently high ACR. Users can change the range of the sample values provided they have a different sample budget. However, IRS is more advantageous when the chosen sample range is small, enabling a more efficient recertification. 
  
  3. The speedup results reported in the paper are for $count=500$ images. One can change to a smaller value for faster run of all experiments. However, the average speedup result may vary depending on this value.
  
 4. For the main experiments in the paper, we used $N = 10^4$ samples for the certification of the original network. However, this parameter can be modified depending on the user’s sample budget. As shown in the paper, increasing the value of $N$ (ie. to $10^5$ or $10^6$) results in greater speedup for IRS over baseline recertification from scratch. 
  
  5. Int8 quantization is run on CPU as current dynamic quantization in PyTorch only supports CPU. Consequently, experiments with int8 quantization take longer time to run than other approximations, which run in GPU.
  
  #### Instructions for Running Main Experiments
  All experiments are found in `nnverify/tests/test_incremental_smoothing.py`
  
  A single experiment runs the certification of the original network using randomized smoothing, the certification of the modified network  using incremental randomized smoothing, and the certification of the modified network using randomized smoothing from scratch for a particular approximation and $\sigma$.

 One can run a single experiment from the test using the following command. 
 
 `python -m unittest -v nnverify.tests.test_incremental_smoothing.irs_plot.test_cifar10_resnet110_int8_sigma1`
  
  All experiments in the paper consider multiple combinations of networks and network perturbations for evaluating IRS’ effectiveness in verification compared to the baseline. The goal of the experiments is to compute IRS’ speedup over the baselines.

 Tests across all approximations for a particular network can be run using the following command. 
  
  `python -m unittest -v nnverify.tests.test_incremental_smoothing.irs_plot.test_cifar10_resnet110_sigma1`

 For more consistent results, certification can be run for multiple trials with error bars using the following command.
  
  `python -m unittest -v nnverify.tests.test_incremental_smoothing.irs_plot.test_cifar10_resnet110_int8_sigma1_eb`
 
 In the paper, Figures 3 through 12 and Tables 1, 3, 5, 8, and 9 are the results of these experiments. 
  
 #### How to See the Speedup Results
  The average speedup range is printed at stdout. Detailed results can be viewed in the `results/` directory created when running an experiment. The `results/` folder contains the following for each combination of network, approximation, and $\sigma$:
  1. A txt file of the average speedup in certification time of certifying a particular ACR between IRS and baseline. 
  
  2. Plots of average certified radius vs average certification time, certification accuracy vs average certification time, average certified radius vs sample size, and certification accuracy vs sample size for IRS and baseline. 
  
  3. Plots of the distribution of $\underline{pA}$ values for the perturbed network certified with baseline randomized smoothing.
  
  4. A summary.txt file with the ACR, average $ζx$ values, average certification times, and proportion of $\underline{pA}$ of the original network greater than the threshold parameter $\gamma$.
 
  5. Subfolders of numpy arrays of certification time, average certified radius, and $ζx$ values for each sample size

  6. Pickle files of the result for each sample size
 
  7. A log file with all the console output
 
 #### Other Experiments
  Sensitivity experiments (Table 4) for changing the sample size $N$ can be run using
  
   `python -m unittest -v nnverify.tests.test_incremental_smoothing.irs_plot.n_ablation_cifar10_resnet110`

  Sensitivity experiments for the threshold parameter $\gamma$ (Table 5) can be performed using
  
   `python -m unittest -v nnverify.tests.test_incremental_smoothing.hyperparam.grid_cifar10_resnet110_int8_sigma05`
  
  Tables for standard accuracy of original and modified networks (Table 6) can be generated with 
  
  `python -m unittest -v nnverify.tests.test_incremental_smoothing.accuracy.standard_acc_cifar10_resnet110`
  
  Tables for smoothed accuracy of original and modified networks (Table 7) can be generated with
  
  `python -m unittest -v nnverify.tests.test_incremental_smoothing.accuracy.smoothed_acc_cifar10_resnet110`
  
### Analyzing Stored Results
  `nnverify/smoothing/code/irs_analyze.py` enables the user to run analysis on stored results from the IRS experiments. For instance, the following command can be useed to plot the visualizatiions and generate tables for a particular network, approximation, and $\sigma$.
  
  `python3 nnverify/smoothing/code/irs_analyze.py --dataset CIFAR10 --net resnet110 --approximation int8 --sigma 1.00`
  
  | Parameter Name        | Type           | Description  |
  | ------------- |:-------------:| -----:|
  | `dataset`      | str, choices = 'ImageNet', 'CIFAR10' | The dataset the network was trained on |
  | `net`     | str, choices = 'resnet20', 'resnet50', 'resnet110'      | The torch network. The networks should be placed in nnverify/nets directory. |
  | `approximation`     | str, choices = 'all, 'int8', 'fp16', 'bf16', 'prune5', 'prune10', 'prune20'      | The modification performed on the network |
  | `sigma`     | float      | The noise hyperparmeter used to train and certify the network |
  | `batch`     | int, default = 100      |   Batch Size |
  | `N`     | int, default = 10000      | Number of Samples Used to Certify the Original Network |
  | `N2`     | int, default = 1000      | Number of samples used to certify the modified network using baseline randomized smoothing |
  | `Nchi`     | int, default = 1000      | Number of samples used to certify the modified network with incremental randomized smoothing |
  | `count`     | int, default = 500      | Number of Images to Run Certification On |
  | `alpha1`     | float, default = 0.001      | Randomized Smoothing Failure Probability |
  | `alpha_chi`     | float, default = 0.001      | Chi Estimation Failure Probability |
  | `plot`     | bool, default = True      | Whether or not to plot the stored data |
  | `std_acc`     | bool, default = True      | Whether or not to compute the standard accuracy of the network |
  | `smoothed_acc`     | bool, default = True      | Whether or not to compute the smoothed accuracy of the network |
  | `chi`     | bool, default = True      | Whether or not to compute the mean chi values |
  
### Adding New Experiments
  Similar to existing experiments one can easily add new experiments using a unit test. One can add this test in existing test file `nnverify/tests/test_incremental_smoothing.py` or can create a new test file in `nnverify/tests/`.
  
 More information about the adding unittests in python is available here 
  
  https://docs.python.org/3/library/unittest.html.
 
 A test function looks like following
  
 ```python
  def test_new_testcase(self):
   self.certify_for_each_sample_size_eb(net = config.CIFAR_RESNET_110, dataset = Dataset.CIFAR10, 
   approximation = ap.Quantize(ap.QuantizationType.INT8), N = 10000, sigma = 1.00, reapeats = 3)
  ```
  
  ##### .certify_for_each_sample_size_eb()
  | Parameter Name        | Type           | Description  |
  | ------------- |:-------------:| -----:|
  | `dataset`      | str, choices = 'ImageNet', 'CIFAR10' | The dataset the network was trained on |
  | `net`     | str, choices = 'resnet20', 'resnet50', 'resnet110'      | The torch network. The networks should be placed in `nnverify/nets` directory. |
  | `approximation`     | str, Default = None. choices = None, 'int8', 'fp16', 'bf16', 'prune5', 'prune10', 'prune20'      | The modification performed on the network. Default runs all approximations. |
  | `sigma`     | float, default = 1.00      | The noise hyperparmeter used to train and certify the network |
  | `N`     | int, default = 10000      | Number of Samples Used to Certify the Original Network |
  | `reapeat`     | int, default = 3      | Number of Trials to Run Certification |
    

